// napple1 ncurses Apple 1 emulator
// Copyright (C) 2008 Nobu Hatano
//
// Pom1 Apple 1 Emulator
// Copyright (C) 2000 Verhille Arnaud
// Copyright (C) 2006 John D. Corrado
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include "m6502.h"
#include "memory.h"
#include "keyboard.h"
#include "screen.h"
#include "configuration.h"
#include <ncurses.h>

int main(int argc, char *argv[])
{
	short noreset;

	loadConfiguration();

	if (getReplica1()) {
		if (!loadReplica1()) {
			fprintf(stderr, "Failed loading rom/6502.rom.bin\n");
			return 0;
		}
	} else {
		if (!loadMonitor()) {
			fprintf(stderr, "Failed loading rom/monitor.rom\n");
			return 0;
		}
	}

	initscr(); 

	if (has_colors())
	{
		start_color();
		init_pair(1, COLOR_GREEN, COLOR_BLACK);
		attrset(COLOR_PAIR(1));
	}

	resetScreen();
	resetMemory();
	if (!loadCore())
		loadBasic();
	setSpeed(1000, 50);
	resetM6502();
	startM6502();

	atexit(stopM6502);

	while (handleInput());

	saveConfiguration();
	core();
	endwin(); 
	return 0;
}
